﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;

public class Manager : MonoBehaviour
{
    private bool gameIsFrozen;
    private bool gameEnded;

    [SerializeField]
    private TimerController timerController;

    [SerializeField]
    private MovingCube cube;

    //private int lapNumber;

    void Start()
    {
        setFrozen(true);
        gameEnded = false;
    }

    // Update is called once per frame
    void Update()
    {
        if (cube.transform.position.z > 50 && !gameEnded)
        {
            timerController.EndTimer();
            SetToLeaderboard(timerController.getTimer());
            gameEnded = true;
        }
    }

    public bool getFrozen() { return gameIsFrozen; }
    private void setFrozen(bool b)  {gameIsFrozen = b; }

    //public int getLapNb() { return lapNumber; }
    //public void setLapNb(int i) { lapNumber = i; }

    public void BeginGame()
    {
        setFrozen(false);
        timerController.BeginTimer();
    }

    private void SetToLeaderboard(float time)
    {
        for (int i = 0; i < 6; i++)
        {
            float record = PlayerPrefs.GetFloat("HighScore" + (i + 1).ToString());
            if (time <= record || record == 0.0f)
            {
                for (int j = 5; j > i; j--)
                {
                    PlayerPrefs.SetFloat("HighScore" + (j + 1).ToString(), PlayerPrefs.GetFloat("HighScore" + j.ToString()));
                }
                PlayerPrefs.SetFloat("HighScore" + (i + 1).ToString(), time);
                break;
            }
        }
    }
}
